#include "internal.h"
/*
 * This file is part of RTC, the Remote Tool Control library
 * CSIRO Division of Manufacturing Technology
 *
 * $Id: mutex.c 363 2007-09-10 01:18:03Z roy029 $
 * Robin Kirkham, February 1997 (from PIRAT)
 *
 * mutex.c -- mutex semaphore library
 * This file is included in the os-dependent file
 */

RTC_STATUS rtcMutexCreate(RTC_MUTEX **mutex) {
    /*
     * Create a mutex, and return the pointer to it.
     * Normal Unix doesn't have these at all
     */
    if (! mutex)
        return rtcFatal("NULL mutex pointer");
    return rtc_ok;
}

RTC_STATUS rtcMutexGrab(RTC_MUTEX *mutex) {
    return rtc_ok;
}

RTC_STATUS rtcMutexDrop(RTC_MUTEX *mutex) {
    return rtc_ok;
}

RTC_STATUS rtcMutexFree(RTC_MUTEX *mutex) {
    return rtc_ok;
}
