#include "internal.h"

/*
 * This file is part of RTC, the Remote Tool Control library
 * CSIRO Division of Manufacturing Technology
 *
 * $Id: message.c 363 2007-09-10 01:18:03Z roy029 $
 * Robin Kirkham, February 1997 (from PIRAT)
 *
 * message.c -- error message store/retrieve
 * This file is included in the os-dependent file
 */

HIDDEN char *rtcMessage = "";

RTC_STATUS rtcMessageSet(char *emessage) {
    /*
     * Set the per-process error message. If the message is NULL,
     * get the message for the current system errno.
     */
    rtcMessage = (emessage) ? emessage : strerror(errno);
    return rtc_ok;
}

char *rtcMessageGet(void) {
    /*
     * Return the current error message
     */
    return rtcMessage;
}

