#include "internal.h"

/*
 * This file is part of RTC, the Remote Tool Control library
 * CSIRO Division of Manufacturing Technology
 *
 * $Id: log.c 363 2007-09-10 01:18:03Z roy029 $
 * Robin Kirkham, February 1997 (from PIRAT)
 *
 * log.c -- message logging function
 * This file is included in the os-dependent module
 */

RTC_STATUS rtcLog(char *format, ...) {
    /*
     * Log a message, similar to fprintf, but sends to the stream
     * selected by the first argument.
     */
    va_list ap;
    va_start(ap, format);

    vfprintf(stderr, format, ap);
    return rtc_ok;
}
