/*
 * This file is part of RTC, the Remote Tool Control library
 * CSIRO Division of Manufacturing Technology
 *
 * $Id: list.c 350 2003-05-12 02:45:56Z sik057 $
 * Robin Kirkham, February 1997 (from PIRAT)
 *
 * list.c -- linked list library
 */
#include "internal.h"


RTC_STATUS rtcListNew(RTC_LIST **list, unsigned size, RTC_LIST **new)
    /*
     * Allocate a new list block with sufficient size for the block
     * itself plus thing, which is assumed to be of the given size. 
     * thing is duplicated into the new storage. The element is then
     * linked into the start of the list pointed to by *point
     */
{
    /* allocate a new block */
    rtc_eret( rtcBufferAlloc(size, (void **)new) );

    /* patch into head of existing list */
    (*new)->next = *list;
    *list = *new;

    return rtc_ok;
}


void rtcListDelete(RTC_LIST **list)
    /*
     * Deallocate the list pointed to by *list and zero *list
     */
{
    RTC_LIST *old;

    if (list)
	old = *list;
    else
	return;

    while (old) {
	RTC_LIST *next = old->next;
	rtcBufferFree(old);
	old = next;
    }
    *list = NULL;
}
