#include "internal.h"

/*
 * This file is part of RTC, the Remote Tool Control library
 * CSIRO Division of Manufacturing Technology
 *
 * $Id: id.c 363 2007-09-10 01:18:03Z roy029 $
 * Robin Kirkham, February 1997 (from PIRAT)
 *
 * id.c -- Unix uid and gid lookup
 * This file is included in the os-dependent file
 */

RTC_STATUS rtcIdUserGet(char *user, int *uid) {
    struct passwd *passwd;

    if (!(passwd = getpwnam(user)))
	return rtcError(NULL);
    if (! uid)
	return rtcFatal("Bad uid return pointer");
    *uid = (int)passwd->pw_uid;
    endpwent();
    return rtc_ok;
}

RTC_STATUS rtcIdGroupGet(char *grnam, int *gid) {
    struct group *group;

    if (!(group = getgrnam(grnam)))
	return rtcError(NULL);
    if (! gid)
	return rtcFatal("Bad gid return pointer");
    *gid = (int)group->gr_gid;
    endgrent();
    return rtc_ok;
}

int rtcIdGet(void) {
    /*
     * Wrapper for getuid()
     */
    return getuid();
}
