/*
 * This file is part of RTC, the Remote Tool Control library
 * CSIRO Division of Manufacturing Technology
 *
 * $Id: buffer.c 350 2003-05-12 02:45:56Z sik057 $
 * Robin Kirkham, February 1997 (from PIRAT)
 *
 * buffer.c -- memory allocator
 */
#include "internal.h"


RTC_STATUS rtcBufferAlloc(unsigned size, void **new) {
    /*
     * Yet another malloc() front-end
     */
    if (! new)
	return rtcFatal("Bad buffer return pointer");
    if (! (*new = malloc(size))) 
	return rtcFatal(NULL);
    memset(*new, 0, size);
    return rtc_ok;
}


RTC_STATUS rtcBufferRealloc(void **old, unsigned size) {
    /*
     * A realloc() front-end
     */
    if (! old)
	return rtcFatal("Bad buffer return pointer");
    if (! (*old = realloc(*old, size)))
	return rtcFatal(NULL);
    return rtc_ok;
}


RTC_STATUS rtcBufferStrdup(char *old, char **new) {
    /* 
     * Yet another strdup() look-alike
     */
    rtc_eret( rtcBufferAlloc(strlen(old) + 1, (void **)new) );
    strcpy(*new, old);
    return rtc_ok;
}


void rtcBufferFree(void *block) {
    free(block);
}
