/*
 *****************************************************************************
 * CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
 * QCAT, PO Box 883, Kenmore, Q 4068, Australia
 *
 *	$Id: plsddx.h 3115 2008-05-19 00:25:09Z roy029 $
 * 
 * Copyright (c) CSIRO Manufacturing Science & Technology
 *****************************************************************************
 */

/**
 *****************************************************************************
 * \file
 * \brief The Sick PLS DDX api header file
 * \author Jonathan Roberts
 *****************************************************************************
 */

#ifndef __plsddx_h
#define __plsddx_h

#include <ddx.h>

/** would be a good idea to use this symbol in the type def below except this
 * does not work,since the struct definition is translated as a string by the
 * preprocessor, without symbol substitution...
**/
#define	PLS_MAX_NSEGS	401

DDX_STORE_TYPE (PlsScan,
	struct {
		int infringe;	/*!< Infringemnet code, 0-3 */
		int status;	/*!< Status code */
		int nSegs;	/*!< Number of segments */
		float res;	/*!< Angular resolution (rad) */
		float first;	/*!< Bearing of first reading (rad) */
		float range[401];	/*!< Range data (m) */
	}
);

DDX_STORE_TYPE (LmsScan,
	struct {
		int infringe;	/*!< Infringemnet code, 0-3 */
		int status;	/*!< Status code */
		int nSegs;	/*!< Number of segments */
		float res;	/*!< Angular resolution (rad) */
		float first;	/*!< Bearing of first reading (rad) */
		float range[401];	/*!< Range data (m) */
		unsigned char intensity[401]; /*!< Intensity data */
	}
);

int plsddx_init(DDX_STORE_ID *storeId, char *name);
int plsddx_done();
int plsddx_read_scan(int id, PlsScan *data, RtxTime *t, double stale, int sync);
int plsddx_write_scan(int id, PlsScan *data, RtxTime *t);
int plsddx_read_mode(int id, int *mode, RtxTime *t, double stale, int sync);
int plsddx_write_cmd(int id, int cmd);
int plsddx_continuous(int id, double timeout);
int plsddx_idle(int id, double timeout);
int plsddx_cartesian_to_scan(double *x, double *y, int n, double theta, double gap, double maxR, PlsScan *scan);

#endif
