/** \example  	plsDDXread.c
 * \brief 	A reader client for the pls
 * \author 	Elliot Duff
 *
 * CSIRO Robotics
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * www.cat.csiro.au/cmst
 *
 * Copyright (c) CSIRO Manufacturing Science & Technology
 *********************************************************************/

static char *rcsid = "$Header$";

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <rtx/message.h>
#include <rtx/time.h>
#include <rtx/error.h>
#include <rtx/main.h>
#include <rtx/thread.h>
#include <plsddx.h> 

int done = 0;
int verbose = 0;
DDX_STORE_ID *storeId;

int
main (int argc, char * argv[])
{
    int i;
    int plsId; 		/* Pls handle */
    int mode;
    PlsScan data;
    RtxTime tsnow;

    rtx_main_init (argv[0], 0);
    if ( argc > 1 ) verbose = atoi(argv[1]);

    /* Create connection to store */

    if (ddx_client_init (verbose) == -1)
	return (rtx_error ("Unable to initialize library"));
    if ((storeId = ddx_store_open (NULL, 0, 5)) == NULL)
        return (rtx_error ("Unable to open store"));

    /* Initialize connection to PLS */

    if ((plsId = plsddx_init(storeId, "pls0")) == -1)
        return (rtx_error ("Unable to initialize PLS"));

    if ((plsddx_read_mode(plsId, &mode, &tsnow, 0.0, 0)) == -1)
        return (rtx_error ("Unable to read scan "));
    printf("Mode %d\n", mode);

    for(i=0; i<10; i++) {
        if ((plsddx_read_scan(plsId, &data, &tsnow, 1.0, 0)) == -1)
          return (rtx_error ("Unable to read scan ")); 
        printf("%d %d %d.%09d %f\n", i, data.nSegs, 
	  tsnow.seconds, tsnow.nanoSeconds, data.range[180]);
        }

    for(i=0; i<10; i++) {
        if ((plsddx_read_scan(plsId, &data, &tsnow, 0.0, 1)) == -1)
          return (rtx_error ("Unable to read scan ")); 
        printf("%d %d %d.%09d %f\n", i, data.nSegs, 
	  tsnow.seconds, tsnow.nanoSeconds, data.range[180]);
        }

    if (plsddx_done()== -1) return (rtx_error ("Unable to close PLS"));
    if (storeId != NULL) ddx_store_close (storeId);
    ddx_client_done ();
    return (0);
}
