/** \file
* Local PIP include file 
*/

#ifndef _LIBPIP_H_    /* prevent accidental re-inclusions */
#define _LIBPIP_H_

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <math.h>
#include <string.h>
#include "pip.h" 

#define TRUE	  1
#define FALSE	  0

#define PI        3.141592654
#define PI2       6.283185308
#define PIO2	  1.570796327
#define RADIANS   57.29577951
#define POWER2(x) ((double)(x) * (double)(x))
#define POWER3(x) ((double)(x) * (double)(x) * (double)(x))

#define SQR(A)	  ((A)*(A))
#define MIN(A,B)  ((A<B)?(A):(B))
#define MAX(A,B)  ((A>B)?(A):(B))
#define ABS(A)    ((A>0)?(A):(-A))
#define CLIP_HIGH(A,B) ((A>B)?(B):(A))
#define CLIP_LOW(A,B) ((A<B)?(B):(A))
#define CLIP(A,B,C) CLIP_HIGH(CLIP_LOW(A,B),C)

/* Internal Warning Messages - that return PIPFAIL */

#define MEMerr    PIPerr("Cannot Allocate Memory")
#define NULerr    PIPerr("Image does not exist")
#define PIPerr(s) { PIPerror("%s %s:%d\n",s,__FILE__,__LINE__); return PIPFAIL;}

/* Internal Warning Messages - that return NULL */

#define MEMern    PIPern("Cannot Allocate Memory")
#define NULern    PIPern("Image does not exist")
#define PIPern(s) { PIPerror("%s %s:%d\n",s,__FILE__,__LINE__); return NULL;}

/* Internal Comments - can be redirected by pip_silent */

void PIPerror(char *s, ...);
void PIPcomment(char *s, ...);

/* Local Queue - used by Label */

typedef struct      { int address; } item_str;
typedef struct cell { item_str item; struct cell *next; } cell_str;
typedef struct      { cell_str *first; cell_str *last; } queue_str;

void queue_init(queue_str *qq);
int  queue_empty(queue_str *qq);
void queue_add(queue_str *qq, item_str *item_a);
int  queue_first(queue_str *qq, item_str *item_r);

/* Routine to open and close files */

FILE *PIPopen(char *, char *);
void  PIPclose(FILE *fp);

#endif /* _LIBPIP_H_ */
