/*********************************************************************
 *
 * CSIRO Automation
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * www.cat.csiro.au/cmst
 *
 * Copyright (c) CSIRO Manufacturing Science & Technology
 *
 *********************************************************************/

/** \file 
Local routines to be used by a number of other functions
Queue routines were modified from routines in Khoros
*/

#define _PIP_EXTERN /*!< Very important to prevent multiply definitions */

#include "local.h" 

void queue_init(queue_str *qq)
  {
  qq->first = (cell_str *) malloc(sizeof(cell_str));
  qq->last = qq->first;
  qq->first->next = (cell_str *) 0;
  }

int queue_empty(queue_str *qq)
  {
  if (qq->first == qq->last) return(1);
  else return(0);
  }

void queue_add(queue_str *qq, item_str *item_a)
  {
  qq->last->next = (cell_str *) malloc(sizeof(cell_str));
  qq->last = qq->last->next;
  qq->last->item = *item_a;
  qq->last->next = (cell_str *) 0;
  }

int queue_first(queue_str *qq, item_str *item_r)
  {
  cell_str *cell;
  if (qq->first == qq->last) return(0);
  cell = qq->first;
  qq->first = qq->first->next;
  *item_r = qq->first->item;
  free(cell);
  return(1);
  }

#include <stdarg.h> 
#ifdef _RT_MESSAGED
#include <useful.h>
#endif

void PIPerror(char *format, ...)
  {
  va_list ap;
  va_start(ap, format);
#ifdef _RT_MESSAGED
  warning(fmt, ap);
#else
  fprintf(stderr, "PIP ERROR: ");
  (void) vfprintf(stderr, format, ap);
  (void) fflush(stderr);
#endif
  }

void PIPcomment(char *format, ...)
  {
  va_list ap;
  if( pip_silent ) return;
  va_start(ap, format);
#ifdef _RT_MESSAGED
  comment(fmt, ap);
#else
  fprintf(stderr, "PIP : ");
  (void) vfprintf(stderr, format, ap);
  (void) fflush(stderr);
#endif
  va_end(ap);
  }

void PIP_version()
  {
  PIPcomment("Version : %s \n", PIP_VERSION);
  PIPcomment("Build   : %s %s\n\n", __TIME__,__DATE__);
  }
