/** \class pip_watershed
* Stand-alone wrapper around watershed function
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-m merge]\tMerge level (default 0.0)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    Pimage *im1, *im2;
    char *in = NULL;
    char *out = NULL;
    double merge = 0.0;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug = 1; break;
	case 'v': pip_silent = 1; break;
	case 's': pip_verbose = 1; break;
        case 'i': in = argv[++i]; break;
        case 'o': out = argv[++i]; break;
	case 'm': merge = atof(argv[++i]); break;
	default : usage(argv[0]); exit(1);
	}
      }

    im1 = PIP_new();
    im2 = PIP_new();
    if( PIP_load(im1, in) ) exit(1); 	
    if( PIP_watershed(im1, im2, merge) ) exit(1);
    if( PIP_save(im2, out) ) exit(1);
    exit(0);
    }
