/** \class pip_unary
* Stand-alone wrapper around pip_unary() function
*/

#include <stdio.h>
#include <stdlib.h>
#define EXTERN extern
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s op {-flag options}\n\n", s);

    fprintf(stderr, "\top\tUnary Operation and Value\n\n");

    fprintf(stderr, "\t\t+{x}\t Add x to image\n");
    fprintf(stderr, "\t\t-{x}\t Subtract x to image\n");
    fprintf(stderr, "\t\t*{x}\t Multply by x \n");
    fprintf(stderr, "\t\t/{x}\t Divide by x \n");
    fprintf(stderr, "\t\t]{x}\t Shift pixel x to right\n");
    fprintf(stderr, "\t\t[{x}\t Shift pixel x to left\n");
    fprintf(stderr, "\t\to{x}\t If pixel is ON then add x\n");
    fprintf(stderr, "\t\t<{x}\t if pixel is LESS than x, then switch ON\n");
    fprintf(stderr, "\t\t>{x}\t if pixel is GREATER than x, then switch ON\n");
    fprintf(stderr, "\t\t={x}\t if pixel is EQUAL to x, then switch ON\n");
    fprintf(stderr, "\t\t^{x}\t if pixel is EQUAL to x, then switch OFF\n");
    fprintf(stderr, "\t\t!\t If pixel is ON then switch OFF and v'versa\n");
    fprintf(stderr, "\t\ti\t Invert Image\n");
    fprintf(stderr, "\n");

    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    Pimage *ip;
    char op = '>';
    int val = 128;
    char *in = NULL;
    char *out = NULL;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{
        op = argv[i][0]; 
	if( argv[i][1] != '\0' ) val = atoi(&argv[i][1]); 
	else val = 0;
	}

      else 
        switch( argv[i][1] )
	  {
	  case 'V': PIP_version(); exit(0);
	  case 'U': usage(argv[0]); exit(0);
	  case 'd': pip_debug = 1; break;
	  case 'v': pip_verbose = 1; break;
	  case 's': pip_silent  = 1; break;
          case 'i': in = argv[++i]; break;
          case 'o': out = argv[++i]; break;
	  default : usage(argv[0]); exit(1);
	  }
      }

    ip = PIP_new();
    if( PIP_load(ip, in) ) exit(1); 	
    if( PIP_unary(ip, op, val) ) exit(1);
    if( PIP_save(ip, out) ) exit(1);
    PIP_free(ip);
    exit(0);
    }
