/** \class pip_transform
* Stand-alone wrapper around PIP_COLOUR function
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput ppm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput ppm file (default stdout)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    fprintf(stderr, "\t[-p plane]\tSelect Plane (0,1,2)\n");
    fprintf(stderr, "\t[-t trans]\tColour Transformation\n");
    fprintf(stderr, "\t    RGBtoHLS - Hue, Lum, Sat\n");
    fprintf(stderr, "\t    RGBtoYIQ - warning not valid\n");
    fprintf(stderr, "\t    RGBtoYUV - warning not valid\n");
    fprintf(stderr, "\t    RGBtoYCrCb - for 0 to 255 data\n");
    fprintf(stderr, "\t    YCrCbtoRGB - for 0 to 255 data (for BT848)\n");
    fprintf(stderr, "\t    RGBtoYCrCbo - for 16 to 235 data \n");
    fprintf(stderr, "\t    YCrCbtoRGBo - for 16 to 235 data\n");
    fprintf(stderr, "\tIf no plane is selected, 3 planes will be written\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    Pimage *rgb[3];
    int plane = -1;
    char *in = NULL;
    char *out = NULL;
    char *trans = "Norm";

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') in = argv[i];
      else switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug   = 1; break;
	case 's': pip_silent  = 1; break;
	case 'v': pip_verbose = 1; break;
        case 'i': in    = argv[++i]; break;
        case 'o': out   = argv[++i]; break;
	case 't': trans = argv[++i]; break;
	case 'p': plane = atoi(argv[++i]); break;
	default : usage(argv[0]); exit(1);
	}
      }

    rgb[0] = PIP_new();
    rgb[1] = PIP_new();
    rgb[2] = PIP_new();

    PIP_loadRGB(rgb, in);

    if( !strcmp(trans, "RGBtoHLS") ) PIP_RGBtoHLS( rgb );
    // else { if( !strcmp(trans, "RGBtoHSI") ) PIP_RGBtoHSI( rgb );
    else { if( !strcmp(trans, "RGBtoYUV") ) PIP_RGBtoYUV( rgb );
    else { if( !strcmp(trans, "RGBtoYIQ") ) PIP_RGBtoYIQ( rgb );
    else { if( !strcmp(trans, "RGBtoYCrCb") ) PIP_RGBtoYCrCb( rgb );
    else { if( !strcmp(trans, "YCrCbtoRGB") ) PIP_YCrCbtoRGB( rgb );
    else { if( !strcmp(trans, "RGBtoYCrCbo") ) PIP_RGBtoYCrCb_original( rgb );
    else { if( !strcmp(trans, "YCrCbtoRGBo") ) PIP_YCrCbtoRGB_original( rgb );
    else { fprintf(stderr, "Unknown Transformation\n"); }}}}}}}

    switch( plane ) {
      case 0: PIP_save(rgb[0], out); break;
      case 1: PIP_save(rgb[1], out); break;
      case 2: PIP_save(rgb[2], out); break;
      default: PIP_saveRGB(rgb, out); break;
      }

    exit(0);
    }
