/** \class pip_time
* Stand-alone wrapper around time function
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile] \tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    Pimage *ip;
    char *in = NULL;
    char *out = NULL;
    struct timespec ts;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') in = argv[i];
      else 
       switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug = 1; break;
	case 'v': pip_verbose = 1; break;
	case 's': pip_silent = 1; break;
        case 'i': in = argv[++i]; break;
        case 'o': out = argv[++i]; break;
	default : usage(argv[0]); exit(1);
	}
      }

/*
   struct tm t;
   time_t tt;

   if( sscanf(date, "%d/%d/%d", &t.tm_mday,&t.tm_mon,&t.tm_year) != 3)
     { warning("Cannot Read Date Field %s\n", date); return NULL; }

   t.tm_sec  = 0; t.tm_hour = 0;
   t.tm_min  = 0; t.tm_mon -= 1;
   t.tm_year -= 1900;

   if( (tt = mktime(&t)) < 0 )
     { warning("Invalid Data Field %s\n", date); return NULL; }
*/

    ip = PIP_new();
    if( PIP_load(ip, in) ) exit(1); 	
    clock_gettime(CLOCK_REALTIME, &ts);
    ip->sec = ts.tv_sec;
    ip->nsec = ts.tv_nsec;
    if( PIP_save(ip, out) ) exit(1);
    exit(0);
    }
