/** \class pip_segment
* Stand-alone wrapper around pip_segment_* functions
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-t type]\tSegmentation Method\n");
    fprintf(stderr, "\t\tkmeans - find two populations\n");
    fprintf(stderr, "\t\tminima - find minimum between two peaks \n");
    fprintf(stderr, "\t\tdarea  - segmentation based upon discriminant area\n");
    fprintf(stderr, "\t[-u] \t\tUpperbound\n");
    fprintf(stderr, "\t[-l] \t\tLowerbound (default)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }


int main(int argc, char *argv[])
    {
    int i;
    char *in = NULL;
    char *out = NULL;
    char *type = "min";
    char op = '<';
    Pimage *ip;
    Phist  histogram;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug = 1; break;
	case 's': pip_silent = 1; break;
	case 'v': pip_verbose = 1; break;
	case 'u': op = '>'; break;
	case 'l': op = '<'; break;
        case 'i': in = argv[++i]; break;
        case 'o': out = argv[++i]; break;
	case 't': type = argv[++i]; break;
	default : usage(argv[0]); exit(1);
	}
      }

    ip = PIP_new();
    if( PIP_load(ip, in) ) exit(1); 	

    switch( type[0] )
      {
      case 'k': case 'K': PIP_segment_kmeans(ip, &histogram); break;
      case 'm': case 'M': PIP_segment_minima(ip, &histogram, 1); break;
      case 'd': case 'D': PIP_segment_darea(ip, &histogram); break;
      case 's': case 'S': PIP_segment_simple(ip, &histogram); break;
      default: fprintf(stderr, "Unknown Segmentation Method\n"); exit(1); 
      }

    if( PIP_unary(ip, op, histogram.mid) ) exit(1);
    if( PIP_save(ip, out) ) exit(1);
    exit(0);
    }
