/** \class pip_seed
* Stand-alone wrapper around pip_seed function
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-c #]\t\tConnectivity (4/8 default)\n");
    fprintf(stderr, "\t[-s # #]\tX and Y position of seed \n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    Pimage *ip;

    char *in = NULL;
    char *out = NULL;
    int cv = 8;
    int x, y, l;
    int lessthan = 0;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'S': pip_silent = 1; break;
	case 'd': pip_debug = 1; break;
	case 'v': pip_verbose = 1; break;
	case 'c': cv = atoi(argv[++i]); break;
        case 'i': in = argv[++i]; break;
        case 'o': out = argv[++i]; break;
	case 's': x = atoi(argv[++i]); y = atoi(argv[++i]); break;
	case 'l': l = atoi(argv[++i]); break;
	case 'L': lessthan = 1; break;
	default : usage(argv[0]); exit(1);
	}
      }

    if( lessthan ) cv = -cv;

    ip = PIP_new();
    if( PIP_load(ip, in) ) exit(1); 	
    ip->c1 = x;
    ip->r1 = y;
    if( PIP_seed(ip, cv, l) ) exit(1); 
    if( PIP_swapmask(ip) ) exit(1); 
    if( PIP_save(ip, out) ) exit(1);
    exit(0);
    }
