/** \class pip_plane
Stand-alone wrapper around xxxx function

Usage: \ref pip_plane
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput ppm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-p plane]\tExtract plane [0,1,2] (default 0)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i, plane = 0;
    Pimage *rgb[3];
    char *in = NULL;
    char *out = NULL;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') in = argv[i]; 
      else switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug   = 1; break;
	case 'v': pip_verbose = 1; break;
	case 's': pip_silent  = 1; break;
	case 'p': plane  = atoi(argv[++i]); break;
        case 'i': in     = argv[++i]; break;
        case 'o': out    = argv[++i]; break;
	default : usage(argv[0]); exit(1);
	}
      }

    if( plane < 0 || plane > 2 ) { printf("Invalid Plane %d\n", plane); exit(-1); }

    rgb[0] = PIP_new();
    rgb[1] = PIP_new();
    rgb[2] = PIP_new();

    if( PIP_loadRGB(rgb, in) == PIPFAIL ) exit(1); 	
    if( PIP_save(rgb[plane], out) == PIPFAIL ) exit(1);

    exit(0);
    }
