/** \class pip_overlay
* Colour Overlay 
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-m maskfile]\tInput ppm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    Pimage *rgb[3], *ip;

    char *grey   = NULL;
    char *out  = NULL;
    char *mask = NULL;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug   = 1; break;
	case 's': pip_silent  = 1; break;
	case 'v': pip_verbose = 1; break;
        case 'i': grey = argv[++i]; break;
        case 'o': out  = argv[++i]; break;
        case 'm': mask = argv[++i]; break;
	default : usage(argv[0]); exit(1);
	}
      }

    ip  = PIP_new();
    rgb[0] = PIP_new();
    rgb[1] = PIP_new();
    rgb[2] = PIP_new();

    if( PIP_load(ip, grey) ) exit(1); 	
    if( PIP_loadRGB(rgb, mask) ) exit(1); 	
    if( PIP_overlay(rgb, ip) ) exit(1); 	
    if( PIP_saveRGB(rgb, out) ) exit(1);
    exit(0);
    }
