/** \class pip_moment
* Stand-alone wrapper around xxxx function
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    Pimage *ip;
    Pmoment *moment;
    float ratio;
    char *in = NULL;
    char *out = NULL;
    FILE *fp;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug = 1; break;
	case 'v': pip_verbose = 1; break;
	case 's': pip_silent = 1; break;
        case 'i': in = argv[++i]; break;
        case 'o': out = argv[++i]; break;
	default : usage(argv[0]); exit(1);
	}
      }

    ip = PIP_new();
    if( PIP_load(ip, in) ) exit(1); 	

    fp = stdout;
    for(i=1; i<255; i++)
      {
      moment = PIP_shape_moment(ip, i);
      if( moment == NULL ) break;
      if( moment->area == 0 ) continue;

      fprintf(fp, "# Moment Features %d\n\n", i);
      fprintf(fp, "Moment_Area \t%g\n", moment->area);
      fprintf(fp, "XCentroid   \t%g\n", moment->xm);
      fprintf(fp, "YCentroid   \t%g\n", moment->ym);

      /* 
      fprintf(fp, "XSigma      \t%g\n", moment->sx);
      fprintf(fp, "YSigma      \t%g\n", moment->sy);
      fprintf(fp, "Theta       \t%g\n", moment->theta*2*PI);
      fprintf(fp, "Eccentricity\t%g\n", moment->eccen);
      fprintf(fp, "Major_Axis  \t%g\n", moment->major);
      fprintf(fp, "Minor_Axis  \t%g\n", moment->minor);
      */

      ratio = moment->major / moment->minor;

      /* remove blob from image */
      if( ratio < 0.5 || ratio > 2 ) PIP_unary(ip, '^', i); 
      }

    if( PIP_save(ip, out) ) exit(1); 	
    exit(0);
    }
