/** \class pip_maths
* Stand-alone wrapper around PIP_MATHS function
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s op {-flag options}\n", s);
    fprintf(stderr, "\top\tMaths Operation\n");
    fprintf(stderr, "\t&\tout = if( im1 && im2 ) then ON else OFF\n");
    fprintf(stderr, "\t|\tout = if( im1 || im2 ) then ON else OFF\n");
    fprintf(stderr, "\t!\tout = if( im1 XOR im2 ) then ON else OFF\n");
    fprintf(stderr, "\tm\tout = if( !im2 ) then OFF (mask)\n");
    fprintf(stderr, "\tx\tout = if( im2 ) then OFF (exclusive mask)\n");
    fprintf(stderr, "\to\tout = if( im2 ) then ON (!mask)\n");
    fprintf(stderr, "\t+\tout = im1 + im2\n");
    fprintf(stderr, "\t-\tout = im1 - im2\n");
    fprintf(stderr, "\t*\tout = im1 * im2\n");
    fprintf(stderr, "\t/\tout = im1 / im2\n");
    fprintf(stderr, "\tM\tout = MAX(im1,im2)\n");
    fprintf(stderr, "\tm\tout = MIN(im1,im2)\n\n");
    fprintf(stderr, "\t[-i im1]\tFirst Input pgm file (default stdin)\n");
    fprintf(stderr, "\t[-I im2]\tSecond Input pgm file (default none)\n");
    fprintf(stderr, "\t[-o out]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    Pimage *im1, *im2;
    char *in1 = NULL;
    char *in2 = NULL;
    char *out = NULL;
    char op = 0;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
         op = argv[i][0];

      else switch( argv[i][1] )
	{
	case 0: op = '-'; break;
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug = 1; break;
	case 's': pip_silent = 1; break;
	case 'v': pip_verbose = 1; break;
        case 'i': in1 = argv[++i]; break;
        case 'I': in2 = argv[++i]; break;
        case 'o': out = argv[++i]; break;
	default : usage(argv[0]); exit(1);
	}
      }

    if( op == 0 ) { usage(argv[0]); exit(1); }

    im1 = PIP_new();
    im2 = PIP_new();
    if( PIP_load(im1, in1) ) exit(1);
    if( PIP_load(im2, in2) ) exit(1);
    if( PIP_maths(im1, op, im2) ) exit(1);
    if( PIP_save(im1, out) ) exit(1);
    exit(0);
    }

