/** \class pip_make
* Stand-alone wrapper around pip_make() function
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-W pixels] \tWidth of image in pixels (def 256))\n");
    fprintf(stderr, "\t[-H pixels] \tHeight of image in pixels (def 256))\n");
    fprintf(stderr, "\t[-b colour] \tBackground grey level (def 0))\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    char *in = NULL;
    char *out = NULL;
    char *name = "PIP_Make";
    int width  = 100;
    int height = 100;
    int colour = 0;
    Pimage *ip;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug   = 1; break;
	case 's': pip_silent  = 1; break;
	case 'v': pip_verbose = 1; break;
        case 'i': in  = argv[++i]; break;
        case 'o': out = argv[++i]; break;
	case 'W': width = atoi(argv[++i]); break;
	case 'H': height = atoi(argv[++i]); break;
	case 'b': colour = atoi(argv[++i]); break;
	case 'n': name = argv[++i]; break;
	default : usage(argv[0]); exit(1);
	}
      }

    ip = PIP_new();
    if( PIP_make(ip, width, height, 255, name) == PIPFAIL ) exit(1); 	
    if( colour > 0 ) PIP_unary(ip, ':', colour);
    PIP_save(ip, out);
    exit(0);
    }
