/** \class pip_label
* Stand-alone wrapper around pip_label function
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-c 4|8] \tConnectivity (default 4)\n");
    fprintf(stderr, "\t[-m min] \tMinimum size (default 10 pixels)\n");
    fprintf(stderr, "\t[-e] \t\tRemove blobs on edge (default False)\n");
    fprintf(stderr, "\t[-f] \t\tFast \n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    Pimage *ip;
    char *in = NULL;
    char *out = NULL;
    int cv    = 4;
    int min   = 10;
    int edge  = 0;
    char type = 'n';

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug = 1; break;
	case 'v': pip_verbose = 1; break;
	case 's': pip_silent  = 1; break;
	case 'e': edge = 1; break;
	case 't': type = argv[++i][0]; break;
        case 'i': in   = argv[++i]; break;
        case 'o': out  = argv[++i]; break;
	case 'c': cv   = atoi(argv[++i]); break;
	case 'm': min  = atoi(argv[++i]); break;
	default : usage(argv[0]); exit(1);
	}
      }

    ip = PIP_new();
    if( PIP_load(ip, in) ) exit(1); 	

    switch( type ) {
        case 'f': PIP_labelf(ip); break;
        case 'n': PIP_label(ip,cv,edge,min); break;
        case 'i': PIP_label_inline(ip,cv,edge,min); break;
        case 'r': PIP_labelr(ip,cv); break;
        }
    if( PIP_save(ip, out) ) exit(1);
    PIP_free(ip);
    exit(0);
    }
