/** \class pip_info
* Stand-alone wrapper around info function
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    Pimage *ip;
    char *in = NULL;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') in = argv[i];
      else 
       switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug = 1; break;
	case 'v': pip_verbose = 1; break;
	case 's': pip_silent = 1; break;
        case 'i': in = argv[++i]; break;
	default : usage(argv[0]); exit(1);
	}
      }

    ip = PIP_new();
    if( PIP_load(ip, in) ) exit(1); 	
    if( PIP_info(ip) ) exit(1);
    exit(0);
    }
