/** \class pip_gwatershed
* Stand-alone wrapper around watershed function
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-c cv]\tConnectivity (4/8) (default 4)\n");
    fprintf(stderr, "\t[-o lw]\tBorder Flag  (0/1) (default 1)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i, cv = 4, lw = 1;
    Pimage *im1;
    char *in = NULL;
    char *out = NULL;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug = 1; break;
	case 'v': pip_silent = 1; break;
	case 's': pip_verbose = 1; break;
        case 'i': in = argv[++i]; break;
        case 'o': out = argv[++i]; break;
	case 'c': cv  = atoi(argv[++i]); break;
	case 'l': lw  = atoi(argv[++i]); break;
	default : usage(argv[0]); exit(1);
	}
      }

    im1 = PIP_new();
    if( PIP_load(im1, in) ) exit(1); 	
    if( PIP_gwatershed(im1, cv, lw) ) exit(1);
    if( PIP_save(im1, out) ) exit(1);
    exit(0);
    }
