/** \class pip_gradient
* Stand-alone wrapper around pip_grey_gradient function
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-g type]\tGradient Type\n");
    fprintf(stderr, "\t\tRoberts\n");
    fprintf(stderr, "\t\tSobel\n");
    fprintf(stderr, "\t\tPrewitt - not available\n");
    fprintf(stderr, "\t\tIsotropic - not available\n");
    fprintf(stderr, "\t[-c dist]\tDistance\n");
    fprintf(stderr, "\t\tcityBlock\n");
    fprintf(stderr, "\t\teuclidean\n");
    fprintf(stderr, "\t\txdirection\n");
    fprintf(stderr, "\t\tydirection\n");
    fprintf(stderr, "\t\tradial\n");
    fprintf(stderr, "\t[-x seed] \t\tX Seed point (default center)\n");
    fprintf(stderr, "\t[-y seed] \t\tY Seed point (default center)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i, x=-1, y=-1;
    Pimage *ip;
    char *in = NULL;
    char *out = NULL;
    char *type = "sobel";
    char *dist = "city";

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug = 1; break;
	case 's': pip_silent = 1; break;
	case 'v': pip_verbose = 1; break;
        case 'i': in = argv[++i]; break;
        case 'o': out = argv[++i]; break;
	case 'g': type = argv[++i]; break;
	case 'c': dist = argv[++i]; break;
	case 'x': x = atoi(argv[++i]); break;
	case 'y': y = atoi(argv[++i]); break;
	default : usage(argv[0]); exit(1);
	}
      }

    ip = PIP_new();
    if( PIP_load(ip, in) ) exit(1); 	
    ip->c1 = ( x > -1 && x < ip->nc ) ? x : ip->nc / 2;
    ip->r1 = ( y > -1 && y < ip->nr ) ? y : ip->nr / 2;
    if( PIP_gradient(ip, type, dist) ) exit(1);
    if( PIP_save(ip, out) ) exit(1);
    exit(0);
    }
