/** \class pip_frame
* Stand-alone wrapper around "pip_crop" function
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-r r1] [-R r2]\tStart & Finish Row (default 0,max)\n");
    fprintf(stderr, "\t[-c c1] [-C c2]\tStart & Finish Col (default 0,max)\n");
    fprintf(stderr, "\t[-b r1 c1 r2 c2] \tBox (default 0,0,max,max))\n");
    fprintf(stderr, "\t[-e edge] \tRemove Edge (default 0)\n");
    fprintf(stderr, "\t[-H height] \tHeight of Crop Window (default max)\n");
    fprintf(stderr, "\t[-W width] \tWidth of Crop Window (default max)\n");
    fprintf(stderr, "\t[-f frame] \tColour (grey) of frane (default 0)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    char *in = NULL;
    char *out = NULL;
    int c=0, C=0, w=0;
    int r=0, R=0, h=0;
    int e=0, f=0;
    Pimage *ip;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug   = 1; break;
	case 's': pip_silent  = 1; break;
	case 'v': pip_verbose = 1; break;
        case 'i': in = argv[++i]; break;
        case 'o': out = argv[++i]; break;

	case 'e': e = atoi(argv[++i]); break;
	case 'c': c = atoi(argv[++i]); break;
	case 'C': C = atoi(argv[++i]); break;
	case 'r': r = atoi(argv[++i]); break;
	case 'R': R = atoi(argv[++i]); break;
	case 'W': w = atoi(argv[++i]); break;
	case 'H': h = atoi(argv[++i]); break;
	case 'f': f = atoi(argv[++i]); break;
	default : usage(argv[0]); exit(1);
	}
      }

    ip = PIP_new();
    if( PIP_load(ip, in) ) exit(1); 	

    if( w > 0 ) C = c + w; if( C == 0 ) C = ip->nc;
    if( h > 0 ) R = r + h; if( R == 0 ) R = ip->nr;
    if( C < 0 ) C = ip->nc + C;
    if( R < 0 ) R = ip->nr + R;
    if( e > 0 ) { c = e; r = e; C= ip->nc-e; R = ip->nr-e; }

    /* Load Crop window onto image */

    if( PIP_roi(ip, r,c,R,C) ) exit(-1);
    if( PIP_frame(ip, (pixel) f) ) exit(-1);
    if( PIP_save(ip, out) ) exit(-1);
    exit(0);
    }
