/** \class pip_erode
* Stand-alone wrapper around pip_binary_erode function
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-n num]\t# of Neighbours that are OFF (default 1)\n");
    fprintf(stderr, "\t[-r times]\t# of Times to repeat (default 1)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-s] \t\tSilent mode\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    Pimage *ip;

    char *in = NULL;
    char *out = NULL;
    int num   = 1;
    int times = 1;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug   = 1; break;
	case 'v': pip_verbose = 1; break;
	case 's': pip_silent  = 1; break;
        case 'i': in    = argv[++i]; break;
        case 'o': out   = argv[++i]; break;
	case 'n': num   = atoi(argv[++i]); break;
	case 'r': times = atoi(argv[++i]); break;
	default : usage(argv[0]); exit(1);
	}
      }

    ip = PIP_new();
    if( PIP_load(ip, in) == PIPFAIL ) exit(1); 	
    for(i=0; i<times; i++) if( PIP_erode(ip, num) ) exit(1);
    if( PIP_save(ip, out) ) exit(1);
    exit(0);
    }
