/** \class pip_edge
* Stand-alone wrapper around pip_edge() function
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-r] \t\tRemove Edge (default Detect)\n");
    fprintf(stderr, "\t[-e] \t\tExtend Edge (default Detect)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    Pimage *ip;
    char *in  = NULL;
    char *out = NULL;
    Pedge flag = PIP_EDGE_DETECT;
    int edge;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug = 1; break;
	case 'v': pip_verbose = 1; break;
	case 's': pip_silent = 1; break;
        case 'i': in = argv[++i]; break;
        case 'o': out = argv[++i]; break;
        case 'e': flag = PIP_EDGE_EXTEND; break;
        case 'r': flag = PIP_EDGE_REMOVE; break;
	default : usage(argv[0]); exit(1);
	}
      }

    ip = PIP_new();
    PIP_load(ip, in);
    edge = PIP_edge(ip, flag);

    if( flag != PIP_EDGE_DETECT ) PIP_save(ip, out);
    else {
      if( edge == PIP_EDGE_NONE ) printf("No ");
      if( edge & PIP_EDGE_NORTH ) printf("North ");
      if( edge & PIP_EDGE_SOUTH ) printf("South ");
      if( edge & PIP_EDGE_WEST ) printf("West ");
      if( edge & PIP_EDGE_EAST ) printf("East ");
      printf("Edge(s) Touch\n");
      }

    exit(0);
    }
