/** \class pip_draw
* Stand-alone wrapper around pip_crop() function
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-b r c w h] \tBox (default 0,0,max,max))\n");
    fprintf(stderr, "\t[-l r c w h] \tLine (default 0,0,max,max))\n");
    fprintf(stderr, "\t[-f r c w h] \tFill (default 0,0,max,max))\n");
    fprintf(stderr, "\t[-e r c w h] \tEllipse (default 0,0,max,max))\n");
    fprintf(stderr, "\t[-c colour] \t\tSet output colour [0-255] (def 255)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    char *in = NULL;
    char *out = NULL;
    int c=0, w=0;
    int r=0, h=0;
    int colour = ON;
    char draw;
    Pimage *ip;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug   = 1; break;
	case 's': pip_silent  = 1; break;
	case 'v': pip_verbose = 1; break;
        case 'i': in = argv[++i]; break;
        case 'o': out = argv[++i]; break;
	case 'c': colour = atoi(argv[++i]); break;

	case 'e': case 'b': case 'l': case 'f':
	  draw = argv[i][1];
	  c = atoi(argv[++i]); r = atoi(argv[++i]); 
	  w = atoi(argv[++i]); h = atoi(argv[++i]); 
	  break;

	default : usage(argv[0]); exit(1);
	}
      }

    ip = PIP_new();
    if( PIP_load(ip, in) == PIPFAIL ) exit(1); 	

    switch( draw ) {
      case 'e': PIP_DrawEllipse(ip, c, r, w, h, colour); break;
      case 'l': PIP_DrawLine(ip, c, r, w, h, colour); break;
      case 'b': PIP_DrawBox(ip, c, r, w, h, colour); break;
      case 'f': PIP_FillBox(ip, c, r, w, h, colour); break;
      }

    PIP_save(ip, out);
    exit(0);
    }
