/** \class pip_colourize
Colour Overlay 

Usage: \ref pip_colourize
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput ppm file (default stdout)\n");
    fprintf(stderr, "\t[-c cmapfile]\tColourmap (need LIBSX env)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    Pimage *ip, *rgb[3];

    char *in  = NULL;
    char *out = NULL;
    char *map = "regions";

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug   = 1; break;
	case 'v': pip_verbose = 1; break;
	case 's': pip_silent  = 1; break;
        case 'i': in  = argv[++i]; break;
        case 'o': out = argv[++i]; break;
        case 'c': map = argv[++i]; break;
	default : usage(argv[0]); exit(1);
	}
      }

    ip = PIP_new();
    rgb[0] = PIP_new();
    rgb[1] = PIP_new();
    rgb[2] = PIP_new();

    if( PIP_load(ip, in) == PIPFAIL ) exit(1); 	
    if( PIP_loadcmap(map) == PIPFAIL ) exit(1);
    if( PIP_colourize(rgb, ip) == PIPFAIL ) exit(1); 	
    if( PIP_saveRGB(rgb, out) == PIPFAIL ) exit(1); 	
    exit(0);
    }
