/** \class pip_chain
Stand-alone wrapper around PIP_chain function

Usage: \ref pip_chain
*/ 

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    Pimage *ip;
    Pimage *op;

    char *in = NULL;
    char *out = NULL;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
	case 'd': pip_debug   = 1; break;
	case 'v': pip_verbose = 1; break;
	case 'v': pip_silent  = 1; break;
        case 'i': in  = argv[++i]; break;
        case 'o': out = argv[++i]; break;
	default : usage(argv[0]); exit(1);
	}
      }

    if((ip = PIP_new()) == NULL) exit(-1);
    if((op = PIP_new()) == NULL) exit(-1);
    if( PIP_load(ip, in) == PIPFAIL )  exit(1); 	
    if( PIP_chain(ip, op) == PIPFAIL ) exit(1);
    if( PIP_save(op, out) == PIPFAIL ) exit(1);
    PIP_free(ip);
    PIP_free(ip);
    exit(0);
    }
