/** 
\class pip_cat
Stand-alone wrapper around PIP_cat function

Usage: \ref pip_cat
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i in1file]\tInput pgm file (default stdin)\n");
    fprintf(stderr, "\t[-2 in2file]\tInput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-p #]\tPad length (in pixels) (default 0)\n");
    fprintf(stderr, "\t[-c #]\tPad colour (as pixel) (default 128)\n");
    fprintf(stderr, "\t[-I] \t\tCatenate Interleave\n");
    fprintf(stderr, "\t[-a] \t\tCatenate Above\n");
    fprintf(stderr, "\t[-b] \t\tCatenate Below\n");
    fprintf(stderr, "\t[-l] \t\tCatenate Left\n");
    fprintf(stderr, "\t[-r] \t\tCatenate Right (default)\n");
    fprintf(stderr, "\t[-s] \t\tMake PIP silent\n");
    fprintf(stderr, "\t[-v] \t\tVerbose output\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    char *in1 = NULL;
    char *in2 = NULL;
    char *out = NULL;
    char side = 'r'; 	/* Catenate to the right */
    int pad = 0;  	/* Pad length - default there is no padding */
    pixel col = 128;  	/* Pad colour - default is mid grey */
    int colour = 0;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'U': usage(argv[0]); exit(0);
        case 'i': in1   = argv[++i]; break;
        case '2': in2   = argv[++i]; break;
        case 'o': out   = argv[++i]; break;
	case 'b': side  = 'b'; break;
	case 'a': side  = 'a'; break;
	case 'l': side  = 'l'; break;
	case 'r': side  = 'r'; break;
	case 'I': side  = 'I'; break;
	case 'p': pad = atoi(argv[++i]); break;
	case 'c': col = atoi(argv[++i]); break;
	case 'C': colour = 1; break;
	default : usage(argv[0]); exit(1);
	}
      }

    if( !colour )  {
      Pimage *ip1, *ip2;
      ip1 = PIP_new(); if( PIP_load(ip1, in1) ) exit(1); 	
      ip2 = PIP_new(); if( PIP_load(ip2, in2) ) exit(1); 	
      if( pad ) PIP_pad(ip1, side, pad, col);
      if( PIP_cat(ip1, ip2, side) ) exit(1);
      if( PIP_save(ip1, out) ) exit(1);
      free(ip1); free(ip2);
      }
   else {
      Pimage *rgb1[3], *rgb2[3];
      rgb1[0] = PIP_new(); 
      rgb1[1] = PIP_new(); 
      rgb1[2] = PIP_new(); 
      if( PIP_loadRGB(rgb1, in1) ) exit(1); 	

      rgb2[0] = PIP_new(); 
      rgb2[1] = PIP_new(); 
      rgb2[2] = PIP_new(); 
      if( PIP_loadRGB(rgb2, in2) ) exit(1); 	

      if( pad ) { 
	 PIP_pad(rgb1[0], side, pad, col);
	 PIP_pad(rgb1[1], side, pad, col);
	 PIP_pad(rgb1[2], side, pad, col);
	 }

      if( PIP_cat(rgb1[0], rgb2[0], side) ) exit(1);
      if( PIP_cat(rgb1[1], rgb2[1], side) ) exit(1);
      if( PIP_cat(rgb1[2], rgb2[2], side) ) exit(1);

      if( PIP_saveRGB(rgb1, out) ) exit(1);
      }
    exit(0);
    }
