/** \class pip_bivariant
* Wrapper to bivariant histogram image 
*/

#include <stdio.h>
#include <stdlib.h>
#include "pip.h"

static void usage(char *s) 
    { 
    fprintf(stderr, "\nUsage : %s {-flag options}\n\n", s);
    fprintf(stderr, "\t[-i infile] \t1st image file (default stdin)\n");
    fprintf(stderr, "\t[-2 infile] \t2nd image file \n");
    fprintf(stderr, "\t[-o outfile]\tOutput pgm file (default stdout)\n");
    fprintf(stderr, "\t[-d] \t\tDebug mode\n");
    fprintf(stderr, "\t[-V] \t\tPrint Version Number\n");
    fprintf(stderr, "\t[-U] \t\tPrint Usage\n");
    }

int main(int argc, char *argv[])
    {
    int i;
    Pimage *ip1, *ip2, *op;
    char *in1 = NULL;
    char *in2 = NULL;
    char *out = NULL;

    for(i=1; i<argc; i++)
      {
      if( argv[i][0] != '-') 
	{ usage(argv[0]); exit(-1); }

      switch( argv[i][1] )
	{
	case 'V': PIP_version(); exit(0);
	case 'd': pip_debug   = 1; break;
	case 'v': pip_verbose = 1; break;
	case 's': pip_silent  = 1; break;
        case 'i': in1 = argv[++i]; break;
        case '2': in2 = argv[++i]; break;
        case 'o': out = argv[++i]; break;
	default : usage(argv[0]); exit(1);
	}
      }

    ip1 = PIP_new(); if( PIP_load(ip1, in1) ) exit(1); 	
    ip2 = PIP_new(); if( PIP_load(ip2, in2) ) exit(1); 	
    op  = PIP_new(); 

    if( PIP_bivariant(op, ip1, ip2) ) exit(1); 	

    if( PIP_save(op, out) ) exit(1);
    exit(0);
    }
