/*********************************************************************
 * Copyright (c) CSIRO 
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 *********************************************************************/

#ifdef __GNUC__
#define RTX_STATIC_ATTRIBUTE __attribute__((unused))
#else
#define RTX_STATIC_ATTRIBUTE
#endif
static char rcsid[] RTX_STATIC_ATTRIBUTE = "$Header$";

/**
 * \author  Elliot Duff 
 * A simple client program to communicate with Launch 
 * \todo    Proper error handling and list of available commands.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "../include/rtx/main.h"
#include "../include/rtx/inet.h"
#include "../include/rtx/error.h"
#include "../include/rtx/srpc.h"

char *mcAddr = "127.0.0.1";
int   mcPort = 100 + RTX_SRPC_PORT_OFFSET;

char readBuf[8192];
char writeBuf[8192];

int
main (int argc, char * argv[]) {

  int n;
  RtxInet * inetHandle = NULL;

  if ((inetHandle = rtx_inet_init (RTX_INET_TCP_CLIENT,
    NULL, 0, mcAddr, mcPort, NULL, NULL, NULL)) == NULL) {
    rtx_error_flush ("rtx_inet_init failed");
    exit (1);
  }

  if( argc != 2 ) {
    printf("Available commands are :\n");
    printf("\tget_applist\n");
    printf("\tget_status\n");
    printf("\tget_info\n");
    printf("\tget_runlevel\n");
    printf("\tset_runlevel [n]\n");
    printf("Command >");
    if( fgets(writeBuf, 100, stdin) == NULL) exit(0); 
  } else {
    strcpy(writeBuf, argv[1]);
    n = strlen(argv[1]);
    writeBuf[n] = '\n';		// Its Very Important to send a CR for SRPC
    writeBuf[n+1] = 0;
    }
    
  // printf("Sending command (%s) (%d)\n", writeBuf, strlen(writeBuf));

  rtx_inet_write (inetHandle->sock, writeBuf, strlen (writeBuf), NULL);
  n = rtx_inet_read (inetHandle->sock, readBuf, 8191, NULL);
  readBuf[n] = 0;
  printf(readBuf); 

  rtx_inet_done(inetHandle);
  return 0;
}

