#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sched.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <errno.h>
#include <poll.h>
#include <semaphore.h>

#include <rtx/main.h>
#include <rtx/message.h>
#include <rtx/thread.h>
#include <rtx/mutex.h>
#include <rtx/sem.h>
#include <rtx/auth.h>
#include <rtx/lock.h>
#include <rtx/error.h>
#include <rtx/timer.h>
#include <rtx/signal.h>
#include <rtx/list.h>
#include <rtx/command.h>
#include <launchWebCommand.h>

#include <launch.h>

static Launch * l;

int launch_wcmd_register (Launch * lch)
{
	l = lch;
	return 0;
}

int launch_wcmd_up ()
{
    int desLevel;

    desLevel = l->curAppLevel;
    if (l->state == LAUNCH_STATE_STABLE) {
	l->desiredAppLevel = launch_get_next_app_level_up (l, desLevel);
	l->userDesLevel = l->desiredAppLevel;
	if (rtx_sem_post (l->eventSem) == -1)
	    return (rtx_error ("launch_wcmd_up: rtx_sem_post"));
    }
    return (0);
}

int launch_wcmd_down ()
{
    int desLevel;

    desLevel = l->curAppLevel;
    if (l->state == LAUNCH_STATE_STABLE) {
	l->desiredAppLevel = launch_get_next_app_level_down (l, desLevel);
	l->userDesLevel = l->desiredAppLevel;
	if (rtx_sem_post (l->eventSem) == -1)
	    return (rtx_error ("launch_wcmd_down: rtx_sem_post"));
    }
    return (0);
}

int launch_wcmd_go (int level)
{
    int desLevel;

    desLevel = level;
    if ((desLevel < 0) || (desLevel > 255))
        return (rtx_error ("launch_wcmd_go: invalid run level (%d)", desLevel));
    if (l->appsLevel[desLevel] != NULL) {
        l->desiredAppLevel = desLevel;
    } else if (desLevel < l->curAppLevel) {
        l->desiredAppLevel = launch_get_next_app_level_down (l, desLevel);
    } else if (desLevel > l->curAppLevel) {
        l->desiredAppLevel = launch_get_next_app_level_up (l, desLevel);
    }
    l->userDesLevel = l->desiredAppLevel;
    if (desLevel != l->desiredAppLevel)
        rtx_message( "launch_wcmd_go: level %d empty, changing level to %d", 
		 desLevel, l->desiredAppLevel);
    if (l->state == LAUNCH_STATE_STABLE) {
	if (rtx_sem_post (l->eventSem) == -1)
	    return (rtx_error ("launch_wcmd_go: rtx_sem_post"));
    }

    return (0);
}

int launch_wcmd_top ()
{
    if (l->state == LAUNCH_STATE_STABLE) {
	l->desiredAppLevel = l->maxAppLevel;
	if (rtx_sem_post (l->eventSem) == -1)
	    return (rtx_error ("launch_wcmd_go: rtx_sem_post"));
    }
    return (0);
}

int launch_wcmd_bottom ()
{
    if (l->state == LAUNCH_STATE_STABLE) {
	l->desiredAppLevel = 0;
	if (rtx_sem_post (l->eventSem) == -1)
	    return (rtx_error ("launch_wcmd_go: rtx_sem_post"));
    }
    return (0);
}

int launch_wcmd_ls ()
{
    LaunchAppNode * nd = NULL;

    printf ("current level = %d\n\n", l->curAppLevel);
    printf ("level\tname\tstatus\tcommand\n");
    while ((nd = (LaunchAppNode *) rtx_list_iterate 
	    (l->apps)) != NULL) {
        printf ("%d\t%s\t%d [%d]\t%s\n", nd->level, nd->appName, 
		nd->status, (int) nd->appPid, nd->command);
    }
    return (0);
}
