/*
 ********************************************************************
 *
 * launch.c - application launcher
 *
 *     CSIRO Automation
 *     Queensland Centre for Advanced Technologies
 *     PO Box 883, Kenmore, QLD 4069, Australia
 *     www.cat.csiro.au/cmst
 *
 *      $Id: launch-main.c 2304 2008-01-07 06:05:50Z roy029 $
 *
 * Copyright (c) CSIRO Manufacturing Science & Technology
 *
 ********************************************************************
 */

#ifdef __GNUC__
#define RTX_STATIC_ATTRIBUTE __attribute__((unused))
#else
#define RTX_STATIC_ATTRIBUTE
#endif
static char *rcsid RTX_STATIC_ATTRIBUTE = "$Id: launch-main.c 2304 2008-01-07 06:05:50Z roy029 $";

/**
 ********************************************************************
 * 
 * \file launch.c
 * \brief Application launcher
 * \author Pavan Sikka
 */

/**
 * \page launcher Launcher
 *
 * 
 */

#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sched.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <errno.h>
#include <poll.h>

#include <rtx/main.h>
#include <rtx/message.h>
#include <rtx/thread.h>
#include <rtx/mutex.h>
#include <rtx/sem.h>
#include <rtx/auth.h>
#include <rtx/lock.h>
#include <rtx/error.h>
#include <rtx/timer.h>
#include <rtx/signal.h>
#include <rtx/list.h>
#include <rtx/lock.h>
#include <rtx/command.h>
#include <rtx/getopt.h>
#include <rtx/httpd.h>
#include <rtx/longstring.h>
#include <rtx/scircbuff.h>


#include "launch.h"
#include "launchWebCommand.h"
#include "logMessage.h"

#define MAX_POST_LEN 100000
#define LOG_BUFFER_SIZE 30


/* forward declarations */

int launch_init(Launch * l,int argc, char * argv[]);
int launch_terminate (Launch * l);

/**
 * The launch structure
 */
Launch launch;
RtxCircularStringBuffer* logBuffer = NULL;
log_message* logMess = NULL;
RtxMutex *launchMtx = NULL;


void messageLog(const char * message){
	rtx_csbuffer_push(logBuffer, message);
	if (launch.verbose>1) {
		rtx_csbuffer_dump(logBuffer);
	}
	logMessage_setTabMessage(logMess);
	logMessage_xmlConverter(logMess);	
}



/**
 * The launchweb handler
 */

#define MAX_POST_ITEM_LENGTH 10
int launchweb_handler(RtxHttpdReq * r){
	RtxLongString *str;
	char tmp[512] = "";

	int i;
	char *status;

	Launch * l = &launch;
	LaunchAppNode * nd = NULL;

	// This string will contains the memory representation
	// of the http reply
	str = rtx_longstring_init();

	rtx_mutex_lock(launchMtx);
	if((r->method == RTX_HTTPD_M_GET) && strcmp(r->url,"/logstate")==0){
		//if ((action = rtx_hash_find(r->args,"action"))){
		if (l->verbose) {
			rtx_message("action = refresh\n");
		}
		rtx_longstring_clear(str);
		rtx_longstring_concat(str,rtx_longstring_content(logMess->w));
		//}		
	}else if(r->method == RTX_HTTPD_M_GET && strcmp(r->url,"/launcherstate")==0){
		rtx_longstring_concat(str, "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
		rtx_longstring_concat(str, "<!DOCTYPE launcher SYSTEM \"./launcher.dtd\">");

		rtx_longstring_concat(str, "<launcher>");
		while ((nd = (LaunchAppNode *) rtx_list_iterate (l->apps)) != NULL) {
			if(nd->status == 1){
				status = "running";
			}else{
				status = "available";
			}
			sprintf(tmp,"<process name=\"%s\" status=\"%s\"><level>%d</level><pid>%d</pid><command>%s</command></process>", nd->appName,status,nd->level, (int) nd->appPid, nd->command);
			rtx_longstring_concat(str, tmp);
			memset(tmp, 0, 512);
		}
		rtx_longstring_concat(str, "</launcher>");
	}else if(r->method == RTX_HTTPD_M_POST){
		if(r->content_length > 0){
		  char * actval = (char*)rtx_hash_find(r->post,"action", (rtx_error_t)NULL);
			if (actval) {
				if(strcmp(actval,"up") == 0){
					launch_wcmd_up ();
				}else if(strcmp(actval, "down") == 0){
					launch_wcmd_down ();
				}else if(strcmp(actval, "top") == 0){
					launch_wcmd_top();
				}else if(strcmp(actval, "bottom") == 0){
					launch_wcmd_bottom();
				}else if(strcmp(actval,"go") == 0){
				  char * level = (char*)rtx_hash_find(r->post,"level", (rtx_error_t)NULL);
					if(level) {
						i = l->curAppLevel;
						sscanf(level,"%d",&i);
						launch_wcmd_go(i);
					}
				}
			}

		}
	}
	rtx_mutex_unlock(launchMtx);

	if(rtx_httpd_reply_send_status(r, 200, NULL) != 0){
		return rtx_error("Could not set HTTP response status");
	}

	if(rtx_httpd_reply_send_header(r, "Content-Type", "text/xml") != 0){
		return rtx_error("Could not set Content Type");
	}

	if(rtx_httpd_reply_send_body(r,rtx_longstring_content(str), rtx_longstring_length(str))!=0)
		return rtx_error("could not send response");

	rtx_longstring_destroy(str);

	return 0;
}

/**
 * main program
 */
int
main (
		int argc,          /**< number of tokens on the command line */
		char * argv[]      /**< command-line tokens */
	 )
{
	Launch * l = &launch;
	RtxHttpd * server = NULL;

	if (launch_init(l,argc,argv)) {
		return 1;
	}

	launch_wcmd_register(l);

	if (l->webFlag) {
		launchMtx = rtx_mutex_init(NULL,0,0);
		logBuffer = rtx_csbuffer_init(NULL,LOG_BUFFER_SIZE);
		logMess = logMessage_init(logBuffer);
		rtx_message_init("weblaunch",RTX_MESSAGE_CUSTOM|RTX_MESSAGE_MESSAGE);
		rtx_message_set_custom_destination(messageLog);

		fprintf(stderr, "Initialising simple HTTPD server on port %d [debug=%d]\n",l->webPort,1);
		server = rtx_httpd_server_init(NULL,l->webPort,5,launchweb_handler);
	} else {
		rtx_message_init("weblaunch",RTX_MESSAGE_MESSAGE);
	}


	if (! l->errors) {
		fprintf(stderr, "launch: up\n");
		if (l->commandLineReqd) {
			rtx_command_handler (launchCmds, "launch-> ");
		} else {

			if (rtx_main_wait_shutdown (0)) {
				rtx_error ("main: rtx_init_wait_shutdown() failed");
				l->errors++;
			} else {
				fprintf (stderr, "launch: shutting down...\n");
			}

		}
	} else {
		rtx_error ("main: shutting down due to errors");
	}
	if (l->webFlag) {
		if (server) {
			rtx_httpd_server_destroy(server);
		}
	}
	if (launch_terminate(l)) {
		return (1);
	}
	if (logMess) {
		logMessage_destroy(logMess);
	}
	if (logBuffer) {
		rtx_csbuffer_destroy(logBuffer);
	}
	if (launchMtx) {
		rtx_mutex_destroy(launchMtx);
	}
	return (0);
}

