/** \example test2.c
* 
* Another launch test program
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <sched.h>
#include <string.h>
#include <errno.h>
#include <rtx/message.h>

static sigset_t signalSet;

static int      signals[] = {
        SIGTSTP,
        SIGINT,
        SIGQUIT,
        0
};

int my_killer_wait(int prio);

int
main ()
{
    char hostName[64];
    pid_t myPid, myPpid;
    int sig;

    myPid = getpid ();
    myPpid = getppid ();
    gethostname (hostName, 64);

    rtx_message ("test2 (%s:%d) up", hostName, myPid);

    sig = my_killer_wait (99);

    rtx_message ("test2 (%s:%d) done on signal %d", hostName, myPid, sig);
    exit (0);
}

int
my_killer_wait(int prio)
{
	int	signalIndex;
	struct sched_param	schedulingParameters;
	int sig;

	/*
	 * Prepare the signal set
	 */
	if(sigemptyset(&signalSet)) {
		rtx_message_warning("killer_wait: sigemptyset() failed: %s\n", strerror(errno));
		return -1;
	}

        /*
         * Load the killing signals
         */
        for(signalIndex=0; signals[signalIndex] != 0; signalIndex++)
		if( sigaddset(&signalSet, signals[signalIndex])) {
                        rtx_message_warning("killer_wait: sigaddset() failed: %s\n", strerror(errno));
                        return -1;
                }
	/*
	 * Set the priority of the thread to prio
	 */
	 schedulingParameters.sched_priority = prio;

        /*
         * Wait to receive a kill signal and then shut everything down
         */
	if( sigwait( &signalSet, &sig) < 0) {
		rtx_message_warning("killer_wait: sigwait() failed: %s\n", strerror(errno));
		return -1;
	}

	return sig;
}

