/** \example test1.c
*
* A program that is launch aware
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <rtx/message.h>
#include <rtx/main.h>
#include <rtx/error.h>

int
main (int argc, char * argv[])
{
    char hostName[64];
    pid_t myPid, myPpid;
    int sig;
    char * xp;

    myPid = getpid ();
    myPpid = getppid ();
    gethostname (hostName, 64);
    xp = getenv ("LAUNCHER");

    if (xp == NULL)
        rtx_message_routine ("test1 (%s:%d) up", hostName, myPid);
    else
        rtx_message_routine ("test1 (%s:%d) up, LAUNCH = %s", hostName, myPid, xp);
	rtx_main_init("test1",RTX_ERROR_STDERR);

    sig = rtx_main_wait_shutdown (0);

	if (argc > 1) {
		fprintf(stderr,"I will not die!!!!\n");
		while (1) {
			sleep(1);
			fprintf(stderr,"I'm alive!!!!\n");
		}
	}

	return sig;

    rtx_message_routine ("test1 (%s:%d) done on signal %d", hostName, myPid, sig);
    exit (0);
}

