/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: state.c 365 2003-05-12 02:31:19Z sik057 $
 *
 * state.c -- IIO shared global state
 * Robin Kirkham, June 1996
 */
#include "internal.h"

    /* pointer to the state structure */
IIO_STATE *iio_state = NULL;

IIO_STATUS iio_state_init(void) {
    /*
     * Establish and initialise the iio state structure. In a shared memory
     * OS, or a kernel, this is shared; in a process system it isn't, but it
     * is treated the same anyway
     */

    /* refuse to make the state more than once */
    if (iio_state && iio_state->magic == iio_magic_state)
	return iio_fatal("Re-initialisation attempted");

    /* create structure */
    iio_eret( iio_mem_alloc(sizeof(IIO_STATE), (void **)&iio_state));

    /* the magic number */
    iio_state->magic = iio_magic_state;

    /* the list heads */
    iio_state->map = NULL;
    iio_state->minfo = NULL;
    iio_state->module = NULL;
    iio_state->chnode = NULL;
    iio_state->open = NULL;

    /* create process-wide core state mutex */
    iio_eret( iio_mutex_create(&iio_state->mutex) );

    /* create process-wide open-channel list mutex */
    iio_eret( iio_mutex_create(&iio_state->omutex) );

    return iio_status_ok;
}
