/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: standard.c 3223 2008-06-03 01:38:49Z ale077 $
 *
 * standard.c -- the "standard" set of module drivers
 * Robin Kirkham, July 1996
 */
#include "internal.h"

extern IIO_STATUS iio_adam4012(void);
extern IIO_STATUS iio_adam4017(void);
extern IIO_STATUS iio_adam4520(void);
extern IIO_STATUS iio_atc40(void);
extern IIO_STATUS iio_automio(void);
extern IIO_STATUS iio_automgenio(void);
extern IIO_STATUS iio_bvmipadc(void);
extern IIO_STATUS iio_dmm32at(void);
extern IIO_STATUS iio_ipdac(void);
extern IIO_STATUS iio_ipdigital24(void);
extern IIO_STATUS iio_ipdualpit(void);
extern IIO_STATUS iio_ipquadrature(void);
extern IIO_STATUS iio_ipserial(void);
extern IIO_STATUS iio_ipservo(void);
extern IIO_STATUS iio_ipwatchdog(void);
extern IIO_STATUS iio_isapc(void);
extern IIO_STATUS iio_mvme160(void);
extern IIO_STATUS iio_mvme1600(void);
extern IIO_STATUS iio_pcgp(void);
extern IIO_STATUS iio_pcpp(void);
extern IIO_STATUS iio_tews850(void);
extern IIO_STATUS iio_vipc610(void);
extern IIO_STATUS iio_vmivme2532a(void);
extern IIO_STATUS iio_vmivme4100(void);
extern IIO_STATUS iio_mbusadm35010(void);
extern IIO_STATUS iio_mbusadi35000(void);
extern IIO_STATUS iio_mbusaao12000(void);
extern IIO_STATUS iio_mbusaai14000(void);
extern IIO_STATUS iio_mbusaai03000(void);
extern IIO_STATUS iio_mbusavo0200(void);
extern IIO_STATUS iio_mbusddi3725(void);
extern IIO_STATUS iio_mbusddo3705(void);
extern IIO_STATUS iio_mbusplzmc8p(void);
extern IIO_STATUS iio_mbusavi1400(void);
extern IIO_STATUS iio_mbusehc3020(void);

    /* pointers to module information functions */
IIO_INFOFN iio_standard[] = {
    iio_adam4012,
    iio_adam4017,
    iio_adam4520,
    iio_atc40,
    iio_automio,
    iio_automgenio,
    iio_bvmipadc,
    iio_dmm32at,
    iio_ipdac,
    iio_ipdigital24,
    iio_ipdualpit,
    iio_ipquadrature,
    iio_ipserial,
    iio_ipservo,
    iio_ipwatchdog,
    iio_isapc,
    iio_mvme160,
    iio_mvme1600,
    iio_pcgp,
    iio_pcpp,
    iio_tews850,
    iio_vipc610,
    iio_vmivme2532a,
    iio_vmivme4100,
    iio_mbusadm35010,
    iio_mbusadi35000,
    iio_mbusaao12000,
    iio_mbusaai14000,
    iio_mbusaai03000,
	iio_mbusddi3725,
	iio_mbusddo3705,
    iio_mbusavi1400,
    iio_mbusehc3020,
    iio_mbusavo0200,
	iio_mbusplzmc8p,
    NULL
};
