/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: sll.c 365 2003-05-12 02:31:19Z sik057 $
 *
 * sll.c -- ordered singly-linked list 
 * Robin Kirkham, June 1996
 */
#include "internal.h"

IIO_STATUS iio_sll_insert(IIO_SLL **head, IIO_SLL *new, IIO_CMPFN compare) {
    /*
     * Insert the new element into the ordered list, whose first element
     * pointer is pointed to be head. compare() is a function that returns a
     * positive, zero or negative result according to the relative order
     * of its arguments (such as strcmp() for alphabetic strings). The list
     * is in increasing order of compare() result; new elements with equal 
     * compare() result are placed at the END of these groups. If the new
     * element ends up being first in the list, the value of *head changes
     */
    IIO_SLL *point;

    /* check the arguments */
    if (! head)
	return iio_fatal("NULL list head pointer");
    if (! new)
	return iio_fatal("NULL new list object pointer");
    if (! compare)
	return iio_fatal("NULL list compare function");

    /* if list is empty, or new belongs BEFORE the first element */
    if ((! *head) || (compare(new, *head) < 0)) {
	new->next = *head;
	*head = new;
	return iio_status_ok;
    }

    /* otherwise search the list to find the element JUST BEFORE new */
    for (point = *head; point; point = point->next) 

	/* if this is the correct place, or the end */
	if (
	    (compare(new, point) >= 0) &&
	    (!point->next || compare(new, point->next) < 0)
	) {
	    /* link it in AFTER here */
	    new->next = point->next;
	    point->next = new;
	    break;
	}
    return iio_status_ok;
}
