/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: return.c 365 2003-05-12 02:31:19Z sik057 $
 *
 * return.c -- error return functions
 * Robin Kirkham, July 1996
 */
#include "internal.h"


IIO_STATUS iio_return_error(char *emessage, char *file, unsigned int lineno) {
    /*
     * This is called from the iio_error() macro, which passes a user
     * message in emessage (which should be a static or const string pointer)
     * and the filename and line number where the error is generated. The 
     * message is stored for later use in user error messages. If the message
     * is NULL, iio_emessage_set() uses a system message. This function
     * always returns iio_status_error
     */
    iio_emessage_set(emessage);
    return iio_status_error;
}

IIO_STATUS iio_return_fatal(char *emessage, char *file, unsigned int lineno) {
    /*
     * As for iio_return_error(), except an error message is logged, and 
     * iio_status_fatal is returned. This causes the iio_eret/fret() macros
     * to print the call stack as it is unwinds
     */
    char *message;

    iio_emessage_set(emessage);
    message = iio_emessage_get();
    iio_log(
	"IIO: FATAL ERROR: file %s, line %u: %s\n",
	file, lineno, message
    );
    return iio_status_fatal;
}
