/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: string.c 365 2003-05-12 02:31:19Z sik057 $
 *
 * string.c -- generic string functions
 * Robin Kirkham, January 1997
 *
 * This sub-module is intended to be textually included into 
 * one of the os-specific modules 
 */

IIO_STATUS iio_string_cpy(char *dst, char *src) {
    /*
     * As per strcpy()
     * GCC is supposed to in-line strcpy(), but does not seem to
     */
    strcpy(dst, src);
    return iio_status_ok;
}

int iio_string_cmp(char *s1, char *s2) {
    /*
     * As per strcmp()
     * GCC is supposed to in-line strcmp(), but does not seem to
     */
    return strcmp(s1, s2);
}

int iio_string_ncmp(char *s1, char *s2, int len) {
    /*
     * As per strncmp()
     */
    return strncmp(s1, s2, len);
}

int iio_string_len(char *s) {
    /*
     * As per strlen()
     * GCC is supposed to in-line strlen(), but does not seem to
     */
    return strlen(s);
}

char *iio_string_chr(char *s, char c) {
    return strchr(s, c);
}

char *iio_string_pbrk(char *s, char *c) {
    return strpbrk(s, c);
}

IIO_STATUS iio_string_dup(char *old, char **new) {
    /*
     * Allocate per-process memory to hold the string old, copy it,
     * and return pointer to it into new
     */
    if (! old)
	return iio_fatal("NULL string pointer");

    iio_eret( iio_mem_alloc(iio_string_len(old) + 1, (void **)new) );
    iio_string_cpy(*new, old);

    return iio_status_ok;
}

IIO_STATUS iio_string_lookup(char *token, char **table, int *index) {
    /*
     * Compare token against all the string entries in the given table.
     * Put into index the index of the string in the table if found,
     * otherwise return error status
     */
    int ind;

    if (! token || !*token)
	return iio_fatal("NULL or empty lookup string");

    for (ind = 0; table[ind]; ++ind)
	if (iio_string_cmp(token, table[ind]) == 0) {
	    *index = ind;
	    return iio_status_ok;
	}
    return iio_error("String lookup failed");
}
