/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: slog.c 365 2003-05-12 02:31:19Z sik057 $
 *
 * slog.c -- generic slog function
 * Robin Kirkham, January 1997
 *
 * This sub-module is intended to be textually included into 
 * one of the os-specific modules 
 */

IIO_STATUS iio_slog(char *out, char *format, ...) {
    /*
     * Wrapper for sprintf
     */
    va_list ap;
    va_start(ap, format);
    vsprintf(out, format, ap);
    return iio_status_ok;
}

IIO_STATUS iio_vslog(char *out, char *format, va_list ap) {
    /*
     * Wrapper for vsprintf
     */
    vsprintf(out, format, ap);
    return iio_status_ok;
}
