/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: round.c 365 2003-05-12 02:31:19Z sik057 $
 *
 * round.c -- floating point rounding
 * Robin Kirkham, January 1997
 */

int iio_round(double x) {
    /*
     * Return the integer nearest the given real argument x, without using 
     * the floor() function. There used to be a math library 
     * function nint() that did this, but it disappeared
     * 
     * This should be a macro
     */
    return (x > 0.0)
	? (int)(x + 0.5)
	: (int)(x - 0.5);
}
