/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: roughdelay.c 365 2003-05-12 02:31:19Z sik057 $
 *
 * roughdelay.c -- generic roughdelay function
 * Robin Kirkham, January 1997
 *
 * This sub-module is intended to be textually included into 
 * one of the os-specific modules 
 */

IIO_STATUS iio_roughdelay(unsigned ms) {
    /*
     * Delay for roughly at least ms milliseconds using an operating system
     * delay function. This is used to insert non-critical delays
     */
    usleep(ms * 1000);
    return iio_status_ok;
}
