/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Manufacturing Science and Technology
 * $Id: port.c 2222 2007-12-04 11:46:42Z roy029 $
 *
 * port.c -- access non-mapped objects ("ports")
 * Robin Kirkham, August 2000
 *
 * This sub-module is intended to be textually included into 
 * one of the os-specific modules. It is used when port access
 * is not possible; the functions do direct memory access instead,
 * although they probably will never actually get called
 */


IIO_STATUS iio_port_alloc(
    void *paddr, unsigned int psize,
    void **pactual, void **vaddr, unsigned int *vsize
) {
    return iio_error("Port space access not implemented");
}

uint8_t iio_port_get8(volatile uint8_t *addr) {
    return *addr;
}

uint16_t iio_port_get16(volatile uint16_t *addr) {
    return *addr;
}

uint32_t iio_port_get32(volatile uint32_t *addr) {
    return *addr;
}

void iio_port_set8(volatile uint8_t *addr, uint8_t val) {
    *addr = val;
}

void iio_port_set16(volatile uint16_t *addr, uint16_t val) {
    *addr = val;
}

void iio_port_set32(volatile uint32_t *addr, uint32_t val) {
    *addr = val;
}

void iio_port_dump(void) {}
