/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: mem.c 389 2007-01-15 01:41:55Z pra077 $
 *
 * mem.c -- generic memory allocator function
 * Robin Kirkham, January 1997
 *
 * This sub-module is intended to be textually included into 
 * one of the os-specific modules 
 */

IIO_STATUS iio_mem_alloc(unsigned int size, void **new) {
    /*
     * Allocate zeroed memory from per-process memory
     */
    int count;
    char *point;

    if (! new)
	return iio_fatal("NULL return pointer");
    if (! size) {
	*new = NULL;
	return iio_status_ok;
    }
    if (! (point = *new = (void *)malloc(size)))
	return iio_fatal(NULL);
    for (count = 0; count < size; ++count)
	*point++ = 0;
     
    return iio_status_ok;
}

IIO_STATUS iio_mem_free(void *old) {
    /*
     * Free per-process memory
     */
    if (! old)
	return iio_fatal("Free of NULL pointer attempted");
    free(old);
    return iio_status_ok;
}
