/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: log.c 365 2003-05-12 02:31:19Z sik057 $
 *
 * log.c -- generic message logger
 * Robin Kirkham, January 1997
 *
 * This sub-module is intended to be textually included into 
 * one of the os-specific modules 
 */

IIO_STATUS iio_log(char *format, ...) {
    /*
     * Log a message, similar to fprintf, but sends to the stream
     * selected by the first argument.
     */
    va_list ap;
    va_start(ap, format);

    vfprintf(stderr, format, ap);
    return iio_status_ok;
}
