/*
 * This file is part of IIO, the Industrial IO Library
 * CSIRO Division of Manufacturing Technology
 * $Id: file.c 365 2003-05-12 02:31:19Z sik057 $
 *
 * file.c -- generic file function
 * Robin Kirkham, January 1997
 *
 * This sub-module is intended to be textually included into 
 * one of the os-specific modules 
 */

IIO_STATUS iio_file_open(char *name, IIO_FATTR fattr, IIO_FILE *file) {
    /*
     * Re-packages open() for reading an writing
     */
    int fd;
    int mode = 0;

    /* check arguments */
    if (!name || !*name)
	return iio_fatal("NULL or empty file name");
    if (!file)
	return iio_fatal("NULL return pointer");

    /* compute mode */
    mode = 
	((fattr & iio_fattr_rdonly) ? O_RDONLY : 0) |
	((fattr & iio_fattr_wronly) ? O_WRONLY : 0) |
	((fattr & iio_fattr_rdwr) ? O_RDWR : 0) |
	((fattr & iio_fattr_creat) ? O_CREAT : 0) |
	((fattr & iio_fattr_append) ? O_APPEND : 0) |
	((fattr & iio_fattr_trunc) ? O_TRUNC : 0) |
	((fattr & iio_fattr_excl) ? O_EXCL : 0);

    /* open the file, return pointer to file block */
    if ((fd = open(name, mode, 0666)) < 0)
	return iio_error(NULL);

    *file = (IIO_FILE)fd;
    return iio_status_ok;
}

char iio_file_getc(IIO_FILE file) {
    /*
     * Reads one character from file and returns it.
     * On end of file returns the nul character ('\0'), 
     * NOT EOF (which is (char)(-1))
     */
    char ch;
    return ((read(file, &ch, 1) != 1) || ch == EOF) ? '\0' : ch;
}

IIO_STATUS iio_file_close(IIO_FILE file) {
    /*
     * Close the file 
     */
    close(file);
    return iio_status_ok;
}
